using gov.va.med.vbecs.Common;
using System;
using System.Linq;

namespace gov.va.med.vbecs.BOL
{
    /// <summary>
    /// PendingBloolUnitAboRhModel
    /// </summary>
    public class PendingBloodUnitAboRhModel : PendingTestModel, IPendingBloodUnitTestModel
    {
        /// <summary>
        /// BloodUnitId
        /// </summary>
        public string BloodUnitId { get; set; }
        /// <summary>
        /// BloodUnitModel for Product Code
        /// </summary>
        public BloodUnitModel BloodUnitModel { get; set; }
        /// <summary>
        /// OrderedTestGuid
        /// </summary>
        public Guid? OrderedTestGuid { get; set; }
        /// <summary>
        /// OrderedComponentGuid
        /// </summary>
        public Guid? OrderedComponentGuid { get; set; }
        /// <summary>
        /// UnitResultSetGuid
        /// </summary>
        public Guid ResultSetGuid { get; set; }
        /// <summary>
        /// InterpText
        /// </summary>
        public override string InterpText
        {
            get
            {
                if (AboInterp != null &&
                    RhInterp != null)
                {
                    return AboInterp.TestResultId + " " + RhInterp.TestResultText;
                }

                return "";
            }
        }
        /// <summary>
        /// WorkloadProcessID
        /// </summary>
        public override WorkloadProcessID WorkloadProcessId
        {
            get
            {
                if (AntiD != null &&
                    AntiD.TestResultId != PendingTestHelper.NOT_TESTED_SYMBOL)
                {
                    // AntiD was performed
                    return Common.WorkloadProcessID.AutomatedUnitAboRh;
                }
                else
                {
                    // AntiD was NOT performed
                    return Common.WorkloadProcessID.AutomatedUnitAbo;
                }
            }
        }

        /// <summary>
        /// AntiA
        /// </summary>
        public PendingTestResultModel AntiA
        {
            get
            {
                return GetPendingTestResult(TestType.AntiA, false);
            }
        }
        /// <summary>
        /// AntiB
        /// </summary>
        public PendingTestResultModel AntiB
        {
            get
            {
                return GetPendingTestResult(TestType.AntiB, false);
            }
        }
        /// <summary>
        /// AntiAB
        /// </summary>
        public PendingTestResultModel AntiAB
        {
            get
            {
                return GetPendingTestResult(TestType.AntiAB, false);
            }
        }
        /// <summary>
        /// AntiD
        /// </summary>
        public PendingTestResultModel AntiD
        {
            get
            {
                return GetPendingTestResult(TestType.AntiD, false);
            }
        }
        /// <summary>
        /// DControl
        /// </summary>
        public PendingTestResultModel DControl
        {
            get
            {
                return GetPendingTestResult(TestType.ControlD, false);
            }
        }
        /// <summary>
        /// AboInterp
        /// </summary>
        public PendingTestResultModel AboInterp
        {
            get
            {
                return GetPendingTestResult(TestType.ABOInterp, false);
            }
        }
        /// <summary>
        /// RhInterp
        /// </summary>
        public PendingTestResultModel RhInterp
        {
            get
            {
                return GetPendingTestResult(TestType.RhInterp, false);
            }
        }
        /// <summary>
        /// Validate Test
        /// </summary>
        public TestValidationModel Validate(BloodUnitModel bloodUnitModel)
        {
            return BOL.TestValidation.ValidateUnitABORh(
                        AntiA == null ? string.Empty : AntiA.TestResultId,
                        AntiB == null ? string.Empty : AntiB.TestResultId,
                        AntiAB == null ? string.Empty : AntiAB.TestResultId,
                        AntiD == null ? string.Empty : AntiD.TestResultId,
                        DControl == null ? string.Empty : DControl.TestResultId,
                        AboInterp == null ? string.Empty : AboInterp.TestResultId,
                        RhInterp == null ? string.Empty : RhInterp.TestResultId,
                        bloodUnitModel == null ? string.Empty : bloodUnitModel.UnitAbo,
                        bloodUnitModel == null ? string.Empty : bloodUnitModel.UnitRh,
                        bloodUnitModel == null ? null : (Guid?)bloodUnitModel.BloodUnitGuid,
                        bloodUnitModel == null ? UnitStatusCode.Unknown : bloodUnitModel.UnitStatusCode);

        }
    }
}



